

 
 
 /***************************************************************************************************************
  *                                Example_1. ET-REMOTE MP3 Trig-Mode By Command                                *
  ***************************************************************************************************************
  *												                                                                *
  * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                                               *
  * Editor         :  uvision3 3.62c                                                                            *       
  * Compiler       : Keil C51 (V8.05 a)                                                                         *
  *															                                                    *
  * Port Interface :                                                                                            *
  *																											    *
  *            I/O : # MCU-89C51RE2 #            # ET-MINI 3TO5TTL #                     # ET-REMOTE MP3 #      *
  *                  ----------------           ----------------------                   -----------------      *
  *                                                                                                             *                                   
  *                  P1[0..7](OUT)   connect   IN0-IN7(#1)<--> OUT0-OUT7(#1)  connect     Trig CH1-CH8          *                                        
  *                  P2[0..7](OUT)   connect   IN0-IN7(#2)<--> OUT0-OUT7(#2)  connect     Trig CH9-CH16         *                            
  *                  +5V             connect   +VIN (#1,#2)<--> +VOUT(#1,#2)  connect     +3.3V                 *
  *                  GND1            connect   GND1 (#1,#2)<--> GND2 (#1,#2)  connect     GND2                  *                                                                 *
  *                                                                                                    		    *
  * UART0(RS232#1) : P3.0 = Rx0                                                                                 *
  *                  P3.1 = Tx0			                                                                        *
  *            	     Baud Rate 9600                                                                             *
  * 																									        *
  *                                                                                          DIP-SW.MODE        *
  *    Sent CMM       5V                                                                      S1=OFF,S2=OFF     *
  *   Tx0  Rx0      --+--                                            +------------------+    DIP-SW.CONFIG      *
  *    ^    ^         |                                              |                  |     S1=OFF,S2=ON      *
  *    |    |         +----------+                                   |          --------+-----------            *
  *    |    |         |          |      -----------------------      |         |     +VOUT3V3       |           *
  *    |    |   ------+-----     +-----|+VIN              +VOUT|-----+    Trig |                    |           *
  *    |    |  |       P1.0 |----|-----|IN0                OUT0|-----|---------|CH1                 |           *
  *    |    +--|P3.0     .  |    |     | .                  .  |     |         | .                  |           *
  *    |       |         .  |    |     | .   ET-MINI3TO5#1  .  |     |         | .                  |           *
  *    |       |         .  |    |     | .                  .  |     |         | .                  |           *
  *    +-------|P3.1   P1.7 |----|-----|IN7                OUT7|-----|---------|CH8                 |           *
  *            |            |    |  +--|G1                   G2|--+  |         |                    |           *
  *            |            |    |  |  +-----------------------+  |  |         |   ET-REMOTE MP3V2  |           *
  *            |            |    +--|--|+VIN              +VOUT|--|--+    Trig |                    |           *
  *            |       P2.0 |-------|--|IN0                OUT0|--|------------|CH9                 |           *
  *            |         .  |       |  | .                  .  |  |            | .                  |           *
  *            |         .  |       |  | .   ET-MINI3TO5#2  .  |  |            | .                  |           *
  *            |         .  |       |  | .                  .  |  |            | .                  |           *
  *            |       P2.7 |-------|--|IN7                OUT7|--|------------|CH16   [Supply]     |           *
  *             -----+------        +--|G1                   G2|--+            |       G2   5V      |           *
  *                  |89C51RE2      |   -----------------------   |             -------+-----+------            *
  *                --+--          --+--                           |                    |     |                  *
  *                 ---            ---                            +--------------------+     |                  *
  *                  -              -                                                  |     +-->5V             *
  *                                                                                  --+--                      *
  *                                                                                  \   /                      *
  *                                                                                   \ /                       *
  *                                                                                                             *
  *                                                                                                             *
  *   ASCII Command For Test :  +----------+-------------+---------------+                                      *
  *                             |Start Byte| Number Song |      End      |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                             |  1Byte   |   2Byte     |    1 Byte     |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                             |    *     |    01-16    |  0x0D (Enter) |                                      *
  *                             +----------+-------------+---------------+                                      *
  *                                                                                                             *
  *                                                                                                             *
  * Last Update     : 5/June/2012                                                                               *   
  * Create By       : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                      *
  *                                                                                                             * 
  *																											    *
  *                                                                                                             *
  ***************************************************************************************************************/ 
						
#include <at89c51xd2.h>
#include <stdio.h>

 unsigned char enter,cmm_cnt=0,cmm_buf[3] ;
 unsigned int counter ;

/****************************************************************
 *       Interrupt Service Timer0 (Interrupt every 1 ms) 	    *
 ****************************************************************/

 void TM0_Mod1() interrupt 1
 {
 
  TF0     = 0         ; //Clear int. flag 
  TH0     = 0xF4      ; //Up date 16bit Reload Timer0
  TL0     = 0x00      ; //0xF400 = 1 ms 

  counter = counter+1 ; //Increment Counter 

 }

/***************************************************
 *                   Function delay ms 			   *
 ***************************************************/

void delay_ms(unsigned int cnt)
 {
   TR0 = 1        ;	//Enable Timer0 INT.
   ET0 = 1        ;	//Set TCON Register ON Timer0
   counter = 0    ; //Clear Counter

   while(counter<cnt){;}

   TR0 = 0       ;  //Set TCON Reg. Off Timer0
   ET0 = 0       ;	//Disable Timer0 Interrupt

 }

/****************************************************
 *           Initial Timer0 Control for delay       *
 ****************************************************/

 void Timer0_Init(void)
  {
   TH0   = 0xF4   ;	//Start Interrupt every 1 ms
   TL0   = 0x00   ;
  	 
   TMOD |= 0x01   ; //Use Timer0 Mode1 16-bit																							    
   ET0   = 0	  ; //Disable Timer0 Interrupt 
   TR0   = 0      ; //Set TCON Reg. Off Timer0
  }


 /********************************************************************
  *        Interrupt Service Routine Receive Data From RS-232  		 *
  ********************************************************************/

 void Rx_data()	interrupt 4	 
  {
	unsigned char ch ;
	 

	if(RI == 1)	          //If Flag RI =  1 is INT.form Rx
	 {
	   ch = SBUF        ; //Get Data

	   RI = 0           ; //Clear Flag 
	 
	   if(ch != 0x0D)           
        {
         //---------------- Keep Command 3 byte : *,cmm,cmm -------------------   
   
         if(cmm_cnt < 3)
           {   
             cmm_buf[cmm_cnt] = ch  ;  // keep data
             cmm_cnt++              ;
           }
        }
   
      //------ Clear Valiable for Recive New Command -------------

       if(ch == 0x0D)               
       {
          enter = 0x0D             ;  
          cmm_cnt = 0              ;  //Clear Counter Command   
       }
	 
	 }  
  }


 /********************************************
  *              Initial UART0               *
  ********************************************/

 void UART0_Init(void)
  {


   BDRCON |= 0x1C  ;  // Select Internal Baud-Rate,enable,0x1E=Fast //0x1C=No fast 	 
   SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
   ES      = 0     ;  //Disable Serial Uart  Interrupt    
  
   BRL     = 0x88  ;  // Baud Rate 9600
   PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   BDRCON |= 0x02  ;  // Set SPD  =1 :Fast BR  
  
   ES      = 1     ;  //Enable Serial Uart  Interrupt 
  
  }


/*****************************************
 **        Function Initial Port        **
 *****************************************/

 void Init_Port(void)
  {
    //--- Set default output Port = 1  ----

   	 P1 = 0xFF  ;  
	 P2 = 0xFF  ;
  }

 

 /****************************************************
  **                                                **
  **              Function Read Command             **
  **                                                **
  ****************************************************/ 


void chk_cmm(void)
{
      char cm1,cm2 ; 

     if(enter == 0x0D)                          // Check Enter
     {  
       enter  = 0x00  ;                        // Clear valiable 'enter'
         
         if(cmm_buf[0]== '*')                   // Check Start Byte
          {       
            cm1 = (cmm_buf[1]-0x30)*10    ;   //Convert CMM Ascii to  decimal colum 10
            cm2 = (cmm_buf[2]-0x30)+cm1   ;   //Convert CMM Ascii to  decimal colum 1
                         
                           
              //------------------ Sent Signal Trig Follow Command -----------------------

           switch(cm2)
             {
              case 1 :     //--------------- TRIG-CH1(P1.0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_0 = 0              ;    //P1.0=0 : Trig-CH1   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_0 = 1              ;    //P1.0=1  
				    
					 TI = 1                ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
                     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;


             case 2 :     //--------------- TRIG-CH2(P1.1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_1 = 0              ;    //P1.1=0 : Trig-CH2   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_1 = 1              ;    //P1.1=1 
					  
				     TI = 1                ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;

              case 3 :     //--------------- TRIG-CH3(P1.2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_2 = 0              ;    //P1.2=0 : Trig-CH3   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_2 = 1              ;    //P1.2=1  
				 
				     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;

              case 4 :     //--------------- TRIG-CH4(P1.3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_3 = 0              ;    //P1.3=0 : Trig-CH4   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_3 = 1              ;    //P1.3=1  
 
                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;
            
              case 5 :     //--------------- TRIG-CH5(P1.4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_4 = 0              ;    //P1.4=0 : Trig-CH5   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_4 = 1              ;    //P1.4=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;
            
              case 6 :     //--------------- TRIG-CH6(P1.5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_5 = 0              ;    //P1.5=0 : Trig-CH6   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_5 = 1              ;    //P1.5=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;
   
              case 7 :     //--------------- TRIG-CH7(P1.6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_6 = 0              ;    //P1.6=0 : Trig-CH7   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0
 
                     P1_6 = 1              ;    //P1.6=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;

              case 8 :     //--------------- TRIG-CH8(P1.7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P1_7 = 0              ;    //P1.7=0 : Trig-CH8   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P1_7 = 1              ;    //P1.7=1  
 
                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;


            
              case 9 :     //--------------- TRIG-CH9(P2.0)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_0 = 0              ;    //P2.0=0 : Trig-CH9   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_0 = 1              ;    //P2.0=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;


             case 10 :     //--------------- TRIG-CH10(P2.1)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_1 = 0              ;    //P2.1=0 : Trig-CH10   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_1 = 1              ;    //P2.1=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;


             case 11 :     //--------------- TRIG-CH11(P2.2)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_2 = 0              ;    //P2.2=0 : Trig-CH11   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_2 = 1             ;    //P2.2=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;


            case 12 :     //--------------- TRIG-CH12(P2.3)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_3 = 0              ;    //P2.3=0 : Trig-CH12   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_3 = 1              ;    //P2.3=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;
		      break;

            case 13 :     //--------------- TRIG-CH13(P2.4)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_4 = 0              ;    //P2.4=0 : Trig-CH13   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_4 = 1              ;    //P2.4=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ; 

              break ;



            case 14 :     //--------------- TRIG-CH14(P2.5)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_5 = 0              ;    //P2.5=0 : Trig-CH14   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_5 = 1              ;    //P2.5=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;
					  
              break ;


             case 15 :     //--------------- TRIG-CH15(P2.6)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_6 = 0              ;    //P2.6=0 : Trig-CH15   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_6 = 1              ;    //P2.6=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;


             case 16 :     //--------------- TRIG-CH16(P2.7)-------------

                     cmm_buf[0] = 0xFF     ;    //Clear buffer cmm
                     cmm_buf[1] = 0xFF     ;
                     cmm_buf[2] = 0xFF     ;              
                      
                     P2_7 = 0              ;    //P2.7=0 : Trig-CH16   

                     delay_ms(20)          ;    //Delay 20 ms for Trig 0

                     P2_7 = 1              ;    //P2.7=1  

                     TI=1                  ;
                     printf("#OK\n\r")     ;    //Sent Echo Command 
				     while(TI == 0){;}	        //Clear Flag TI
                     TI=0                  ;

              break ;

             
            }   // if switch
          } // if cmm
       }  // if enter


}



/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 void main(void) 
 {
    CKCON0 = 0x01 ;  // div 6 clk mode  X2=1
    AUXR   = 0x10 ;  //Set XRAM = 1792 Byte

    Init_Port()       ;
    Timer0_Init()     ;
    UART0_Init()      ;

    EA   = 1          ;  //Enable global Interrupt  

    delay_ms(3000)    ;       //delay for Sync Borad MP3 Ready 

    TI = 1            ;
    printf("########### ET-REMOTE MP3 V2. ==> PLAY TRIG MODE #########\n\r") ;
    while(TI == 0){;}	     //Clear Flag TI
    TI=0              ;

   while(1)
   {    
     chk_cmm() ;
   }   
 
}






